import factory
from factory import post_generation

from django.utils.crypto import get_random_string

from kelvin.courses.models import (
    AssignmentRule, Course, CourseInvite, CourseLessonLink, CourseStudent, Criterion, ExcludedUser, PeriodicCourse,
    PeriodicRoleDigest, RoleDigest, UserCourseInviteActivation,
)


class CourseFactory(factory.DjangoModelFactory):
    owner = factory.SubFactory("kelvin.accounts.factories.UserFactory")
    subject = factory.SubFactory("kelvin.subjects.factories.SubjectFactory")
    project = factory.SubFactory("kelvin.projects.factories.ProjectFactory")

    class Meta:
        model = Course


class CourseLessonLinkFactory(factory.DjangoModelFactory):
    course = factory.SubFactory(CourseFactory)
    lesson = factory.SubFactory("kelvin.lessons.factories.LessonFactory")

    class Meta:
        model = CourseLessonLink


class AssignmentRuleFactory(factory.DjangoModelFactory):
    course = factory.SubFactory(CourseFactory)

    class Meta:
        model = AssignmentRule


class CriterionFactory(factory.DjangoModelFactory):
    assignment_rule = factory.SubFactory(AssignmentRuleFactory)

    class Meta:
        model = Criterion


class CourseInviteFactory(factory.DjangoModelFactory):
    course = factory.SubFactory(CourseFactory)
    key = factory.LazyFunction(get_random_string)

    class Meta:
        model = CourseInvite


class UserCourseInviteActivationFactory(factory.DjangoModelFactory):
    course_invite = factory.SubFactory(CourseInviteFactory)
    user = factory.SubFactory("kelvin.accounts.factories.UserFactory")

    class Meta:
        model = UserCourseInviteActivation


class PeriodicCourseFactory(factory.DjangoModelFactory):
    course = factory.SubFactory(CourseFactory)

    class Meta:
        model = PeriodicCourse

    @post_generation
    def previous(self, create, extracted, **kwargs):
        if not create:
            return

        if extracted:
            self.previous.set(extracted)


class PeriodicRoleDigestFactory(factory.DjangoModelFactory):
    periodic_course = factory.SubFactory(PeriodicCourseFactory)

    class Meta:
        model = PeriodicRoleDigest


class RoleDigestFactory(factory.DjangoModelFactory):
    periodic_role_digest = factory.SubFactory(PeriodicRoleDigestFactory)
    user = factory.SubFactory("kelvin.accounts.factories.UserFactory")

    class Meta:
        model = RoleDigest


class CourseStudentFactory(factory.DjangoModelFactory):
    student = factory.SubFactory("kelvin.accounts.factories.UserFactory")
    course = factory.SubFactory(CourseStudent)

    class Meta:
        model = CourseStudent

    @classmethod
    def _create(cls, target_class, *args, **kwargs):
        date_created = kwargs.pop('date_created', None)
        obj = super()._create(target_class, *args, **kwargs)
        if date_created is not None:
            obj.date_created = date_created
            obj.save()
        return obj


class ExcludedUserFactory(factory.DjangoModelFactory):
    login = factory.LazyFunction(get_random_string)

    class Meta:
        model = ExcludedUser
