from builtins import object

import django_filters

from kelvin.accounts.utils import get_user_projects
from kelvin.common.filters import ListFilter
from kelvin.courses.models import Course


class SourceCourseFilter(django_filters.FilterSet):
    """
    Фильтрация для курсов-источников по id. Можно запрашивать несколько id.
    """
    id = ListFilter(field_name='id')

    class Meta(object):
        model = Course
        fields = ['id']


class SourceCourseProjectFilter(SourceCourseFilter):
    """
    Фильтрация для курсов-источников по id ( от базового класса ) и проектам пользователя
    """
    @property
    def qs(self):
        parent_qs = super(SourceCourseProjectFilter, self).qs
        user_projects = get_user_projects(self.request.user)
        return parent_qs.filter(project__in=user_projects)
