import logging
import pytz
from datetime import datetime

from django.core.management import BaseCommand
from django.db import transaction

from kelvin.courses.models import CourseStudent
from kelvin.results.models import CourseLessonResult, CourseLessonSummary

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Проставление прохождения курса по этике тем, кто прошел квиз"

    def add_arguments(self, parser):
        parser.add_argument(
            '--course_id', type=int, default=1718,
            help='ID курса, который нужно засчитать',
        )
        parser.add_argument(
            '--lesson_id', type=int, default=7763,
            help='ID модуля, за который нужно проставить 100%',
        )
        parser.add_argument(
            '--date_completed', type=str, default="21/02/2022",
            help='Дата прохождения курса',
        )
        parser.add_argument(
            '--student_ids', type=int, nargs="+",
            help='Список ID студентов, которым нужно засчитать курс'
        )

    def handle(self, *args, **options):
        course_id = options['course_id']
        lesson_id = options['lesson_id']

        for student_id in options['student_ids']:
            with transaction.atomic():
                cs, _ = CourseStudent.objects.get_or_create(course_id=course_id, student_id=student_id)
                # completed не обновляем, должен проставиться автоматически
                cs.date_completed = datetime.strptime(options['date_completed'], "%d/%m/%Y")
                cs.save()

                cls = CourseLessonSummary.objects.filter(
                    student_id=student_id,
                    clesson__course_id=course_id,
                    clesson__lesson_id=lesson_id,
                ).first()
                if not cls:
                    logger.error(f"Object CourseLessonSummary doesn't exist for\n"
                                 f"student: {student_id}\n"
                                 f"course: {course_id}\n"
                                 f"lesson: {lesson_id}")
                    return

                clr = CourseLessonResult.objects.filter(summary=cls).first()
                if not clr:
                    logger.error(f"Object CourseLessonResult doesn't exist for summary: {cls}")
                    return

                clr.points = clr.max_points
                clr.answers = {
                    "1": [
                        {
                            "answered": True
                        }
                    ]
                }
                clr.save()

