import logging

from django.core.management.base import BaseCommand

from kelvin.accounts.update_user_courses_task import update_last_users_course_cache

logger = logging.getLogger(__name__)


class Command(BaseCommand):
    help = "Update user course cache"

    def add_arguments(self, parser):
        parser.add_argument(
            '--days', '-d', dest='last_visit_days_ago', type=int, required=True,
            help='Last visit days ago',
        )
        parser.add_argument(
            '--include_nulls', '-n', dest='include_nulls', type=bool, default=False,
            help='Include nulls in last visit',
        )

    def handle(self, *args, **options):
        update_last_users_course_cache(**options)
