from django.db import migrations, models
import kelvin.common.validators
import jsonfield.fields
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('subjects', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('resources', '0001_initial'),
        ('lessons', '0001_initial'),
        ('group_levels', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Course',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0443\u0447\u0435\u0431\u043d\u043e\u0433\u043e \u043a\u0443\u0440\u0441\u0430')),
                ('color', models.CharField(blank=True, max_length=7, verbose_name='\u041e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u044b\u0439 \u0446\u0432\u0435\u0442 \u043a\u0443\u0440\u0441\u0430', validators=[kelvin.common.validators.validate_color])),
                ('free', models.BooleanField(default=False, db_index=True, verbose_name='\u0411\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u043a\u0443\u0440\u0441')),
                ('copyright', models.CharField(max_length=255, verbose_name='\u041a\u043e\u043f\u0438\u0440\u0430\u0439\u0442', blank=True)),
                ('description', models.TextField(verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043a\u0443\u0440\u0441\u0430', blank=True)),
                ('code', models.CharField(null=True, default=None, max_length=8, blank=True, unique=True, verbose_name='\u041a\u043e\u0434 \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0443\u0447\u0435\u043d\u0438\u043a\u0430 \u0432 \u0433\u0440\u0443\u043f\u043f\u0443 \u043a\u0443\u0440\u0441\u0430')),
                ('date_closed', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u044f \u043a\u0443\u0440\u0441\u0430', blank=True)),
                ('price1', models.DecimalField(default=0, verbose_name='\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u0443\u0440\u0441\u0430 \u0432 \u0440\u0443\u0431\u043b\u044f\u0445 \u0437\u0430 \u0433\u043e\u0434', max_digits=15, decimal_places=2)),
                ('price1_text', models.CharField(default='', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0437\u0430 \u0433\u043e\u0434', blank=True)),
                ('price2', models.DecimalField(default=0, verbose_name='\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u0443\u0440\u0441\u0430 \u0432 \u0440\u0443\u0431\u043b\u044f\u0445 \u0437\u0430 \u043f\u043e\u043b\u0433\u043e\u0434\u0430', max_digits=15, decimal_places=2)),
                ('price2_text', models.CharField(default='', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0437\u0430 \u043f\u043e\u043b\u0433\u043e\u0434\u0430', blank=True)),
                ('price3', models.DecimalField(default=0, verbose_name='\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043a\u0443\u0440\u0441\u0430 \u0432 \u0440\u0443\u0431\u043b\u044f\u0445 \u0437\u0430 \u0447\u0430\u0441\u0442\u044c \u043a\u0443\u0440\u0441\u0430', max_digits=15, decimal_places=2)),
                ('price3_text', models.CharField(default='', max_length=255, verbose_name='\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0434\u043b\u044f \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0437\u0430 \u0447\u0430\u0441\u0442\u044c \u043a\u0443\u0440\u0441\u0430', blank=True)),
                ('supports_web', models.BooleanField(default=True, verbose_name='\u041a\u0443\u0440\u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 \u0432\u0435\u0431\u0435')),
                ('supports_ios', models.BooleanField(default=True, verbose_name='\u041a\u0443\u0440\u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 iOS')),
                ('supports_android', models.BooleanField(default=False, verbose_name='\u041a\u0443\u0440\u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u043d\u0430 Android')),
                ('allow_anonymous', models.BooleanField(default=False, verbose_name='\u0410\u043d\u043e\u043d\u0438\u043c\u043d\u043e\u0435 \u043f\u0440\u043e\u0445\u043e\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u0440\u0441\u0430')),
                ('news', models.TextField(verbose_name='\u041d\u043e\u0432\u043e\u0441\u0442\u0438 \u043a\u0443\u0440\u0441\u0430', blank=True)),
                ('info', jsonfield.fields.JSONField(null=True, verbose_name='\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0435 \u043a\u0443\u0440\u0441\u0430', blank=True)),
                ('classes', models.ManyToManyField(to='group_levels.GroupLevel', verbose_name='\u041a\u043b\u0430\u0441\u0441\u044b', blank=True)),
                ('copy_of', models.ForeignKey(related_name='copies', on_delete=django.db.models.deletion.SET_NULL, verbose_name='\u041a\u043e\u043f\u0438\u0435\u0439 \u043a\u0430\u043a\u043e\u0433\u043e \u043a\u0443\u0440\u0441\u0430 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f', blank=True, to='courses.Course', null=True)),
                ('cover', models.ForeignKey(related_name='cover_for_courses', verbose_name='\u041e\u0431\u043b\u043e\u0436\u043a\u0430', blank=True, to='resources.Resource', null=True)),
            ],
            options={
                'ordering': ['id'],
                'verbose_name': '\u041a\u0443\u0440\u0441',
                'verbose_name_plural': '\u041a\u0443\u0440\u0441\u044b',
            },
        ),
        migrations.CreateModel(
            name='CourseLessonLink',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('mode', models.IntegerField(default=1, verbose_name='\u0420\u0435\u0436\u0438\u043c \u0437\u0430\u043d\u044f\u0442\u0438\u044f', choices=[(1, '\u0422\u0440\u0435\u043d\u0438\u0440\u043e\u0432\u043a\u0430'), (2, '\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u0430\u044f \u0440\u0430\u0431\u043e\u0442\u0430'), (3, '\u0412\u0435\u0431\u0438\u043d\u0430\u0440'), (4, '\u0414\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0430')])),
                ('duration', models.IntegerField(null=True, verbose_name='\u0414\u043b\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043d\u044f\u0442\u0438\u044f (\u043c\u0438\u043d\u0443\u0442\u044b)', blank=True)),
                ('finish_date', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0438\u043b\u0438 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True)),
                ('evaluation_date', models.DateTimeField(null=True, verbose_name='\u0412\u0440\u0435\u043c\u044f \u043f\u0443\u0431\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u0438\u043b\u0438 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True)),
                ('max_attempts_in_group', models.IntegerField(default=2, verbose_name='\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a "\u0432 \u0433\u0440\u0443\u043f\u043f\u0435"')),
                ('show_answers_in_last_attempt', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0432\u0435\u0440\u043d\u044b\u0435 \u043e\u0442\u0432\u0435\u0442\u044b \u0432 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 "\u0433\u0440\u0443\u043f\u043f\u044b" \u043f\u043e\u043f\u044b\u0442\u043e\u043a')),
                ('show_all_problems', models.BooleanField(default=True, verbose_name='\u041f\u043e\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0441\u0440\u0430\u0437\u0443 \u0432\u0441\u0435 \u0437\u0430\u0434\u0430\u0447\u0438')),
                ('url', jsonfield.fields.JSONField(verbose_name='\u0410\u0434\u0440\u0435\u0441\u0430 \u0434\u043b\u044f \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0430', blank=True)),
                ('start_date', models.DateTimeField(null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0438 \u0432\u0440\u0435\u043c\u044f \u043d\u0430\u0447\u0430\u043b\u0430 \u0442\u0440\u0430\u043d\u0441\u043b\u044f\u0446\u0438\u0438 \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0430', blank=True)),
                ('comment', models.TextField(verbose_name='\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u043a \u0432\u0435\u0431\u0438\u043d\u0430\u0440\u0443', blank=True)),
                ('order', models.PositiveIntegerField(verbose_name='\u0421\u043e\u0440\u0442\u0438\u0440\u043e\u0432\u043e\u0447\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u0432 \u043a\u0443\u0440\u0441\u0435')),
                ('accessible_to_teacher', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u0443\u0447\u0438\u0442\u0435\u043b\u044e', blank=True)),
                ('lesson_editable', models.BooleanField(default=True, verbose_name='\u041c\u043e\u0436\u043d\u043e \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043d\u044f\u0442\u0438\u0435')),
                ('date_assignment', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043a\u0443\u0440\u0441\u043e\u0437\u0430\u043d\u044f\u0442\u0438\u044f', blank=True)),
                ('date_completed', models.DateTimeField(default=None, null=True, verbose_name='\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043a\u0443\u0440\u0441\u043e\u0437\u0430\u043d\u044f\u0442\u0438\u044f', blank=True)),
                ('access_code', models.CharField(max_length=7, null=True, verbose_name='\u041a\u043e\u0434 \u0437\u0430\u043d\u044f\u0442\u0438\u044f', blank=True)),
                ('copy_of', models.ForeignKey(related_name='copies', on_delete=django.db.models.deletion.SET_NULL, verbose_name='\u041a\u043e\u043f\u0438\u0435\u0439 \u043a\u0430\u043a\u043e\u0433\u043e \u0441\u0446\u0435\u043d\u0430\u0440\u0438\u044f \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f', blank=True, to='courses.CourseLessonLink', null=True)),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441', to='courses.Course')),
                ('diagnostics_text', models.ForeignKey(verbose_name='\u0428\u0430\u0431\u043b\u043e\u043d \u0442\u0435\u043a\u0441\u0442\u0430 \u0434\u043b\u044f \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u043e\u0432 \u0434\u0438\u0430\u0433\u043d\u043e\u0441\u0442\u0438\u043a\u0438', blank=True, to='lessons.TextTemplate', null=True)),
                ('lesson', models.ForeignKey(verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u0435', to='lessons.Lesson')),
            ],
            options={
                'ordering': ['order', 'date_created'],
                'verbose_name': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0439 \u0437\u0430\u043d\u044f\u0442\u0438\u044f \u0432 \u043a\u0443\u0440\u0441\u0435',
                'verbose_name_plural': '\u0421\u0446\u0435\u043d\u0430\u0440\u0438\u0438 \u0437\u0430\u043d\u044f\u0442\u0438\u0439 \u0432 \u043a\u0443\u0440\u0441\u0430\u0445',
            },
        ),
        migrations.CreateModel(
            name='CourseRecommendation',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=128, verbose_name='\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438')),
                ('text', models.TextField(verbose_name='\u0422\u0435\u043a\u0441\u0442 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438', blank=True)),
                ('course', models.ForeignKey(verbose_name='\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u043c\u044b\u0439 \u043a\u0443\u0440\u0441', to='courses.Course')),
                ('image', models.ForeignKey(verbose_name='\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0430 \u0434\u043b\u044f \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438', to='resources.Resource')),
                ('level', models.ForeignKey(verbose_name='\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0433\u0440\u0443\u043f\u043f\u044b \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0430\u0446\u0438\u0438', to='group_levels.GroupLevel')),
            ],
            options={
                'verbose_name': '\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u044f \u043a\u0443\u0440\u0441\u0430',
                'verbose_name_plural': '\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0430\u0446\u0438\u0438 \u043a\u0443\u0440\u0441\u043e\u0432',
            },
        ),
        migrations.CreateModel(
            name='CourseStudent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('course', models.ForeignKey(verbose_name='\u041a\u0443\u0440\u0441', to='courses.Course')),
                ('student', models.ForeignKey(verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': '\u0423\u0447\u0435\u043d\u0438\u043a \u043a\u0443\u0440\u0441\u0430',
                'verbose_name_plural': '\u0423\u0447\u0435\u043d\u0438\u043a\u0438 \u043a\u0443\u0440\u0441\u043e\u0432',
            },
        ),
        migrations.AddField(
            model_name='course',
            name='lessons',
            field=models.ManyToManyField(to='lessons.Lesson', verbose_name='\u0417\u0430\u043d\u044f\u0442\u0438\u044f \u043a\u0443\u0440\u0441\u0430', through='courses.CourseLessonLink', blank=True),
        ),
        migrations.AddField(
            model_name='course',
            name='owner',
            field=models.ForeignKey(verbose_name='\u0412\u043b\u0430\u0434\u0435\u043b\u0435\u0446 \u043a\u0443\u0440\u0441\u0430', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='course',
            name='students',
            field=models.ManyToManyField(related_name='courses', verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a\u0438 \u043a\u0443\u0440\u0441\u0430', to=settings.AUTH_USER_MODEL, through='courses.CourseStudent', blank=True),
        ),
        migrations.AddField(
            model_name='course',
            name='subject',
            field=models.ForeignKey(verbose_name='\u0423\u0447\u0435\u0431\u043d\u044b\u0439 \u043f\u0440\u0435\u0434\u043c\u0435\u0442 \u043a\u0443\u0440\u0441\u0430', to='subjects.Subject'),
        ),
        migrations.CreateModel(
            name='CourseContentManagers',
            fields=[
            ],
            options={
                'verbose_name': '\u041a\u0443\u0440\u0441 \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u043e\u0432',
                'proxy': True,
                'verbose_name_plural': '\u041a\u0443\u0440\u0441\u044b \u043a\u043e\u043d\u0442\u0435\u043d\u0442-\u043c\u0435\u043d\u0435\u0434\u0436\u0435\u0440\u043e\u0432',
            },
            bases=('courses.course',),
        ),
        migrations.CreateModel(
            name='CourseOriginals',
            fields=[
            ],
            options={
                'verbose_name': '\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043a\u0443\u0440\u0441',
                'proxy': True,
                'verbose_name_plural': '\u041e\u0440\u0438\u0433\u0438\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u043a\u0443\u0440\u0441\u044b',
                'permissions': (('view_original_dashboard', 'Can view original course dashboard'),),
            },
            bases=('courses.course',),
        ),
        migrations.CreateModel(
            name='CourseTeachers',
            fields=[
            ],
            options={
                'verbose_name': '\u041a\u0443\u0440\u0441 \u0443\u0447\u0438\u0442\u0435\u043b\u0435\u0439',
                'proxy': True,
                'verbose_name_plural': '\u041a\u0443\u0440\u0441\u044b \u0443\u0447\u0438\u0442\u0435\u043b\u0435\u0439',
            },
            bases=('courses.course',),
        ),
        migrations.AlterUniqueTogether(
            name='coursestudent',
            unique_together=set([('student', 'course')]),
        ),
        migrations.AlterUniqueTogether(
            name='courselessonlink',
            unique_together=set([('course', 'lesson', 'order', 'date_created')]),
        ),
    ]
