# Generated by Django 1.11.10 on 2019-03-10 16:27
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


def transform_journal_to_journal_resource(model):
    def transform(apps, schema_editor):
        Model = apps.get_model('courses', model)
        Resource = apps.get_model('resources', 'Resource')

        for obj in Model.objects.filter(journal__isnull=False):
            obj.journal_resource = Resource.objects.create(file=obj.journal.file)
            obj.save()
            obj.journal_resource.save()  # Чтобы сгенерировалась короткая ссылка

    return transform


def transform_journal_resource_to_journal(model):
    def transform(apps, schema_editor):
        Model = apps.get_model('courses', model)

        for obj in Model.objects.filter(journal__isnull=False):
            obj.journal = obj.journal.file
            obj.save()

    return transform


class Migration(migrations.Migration):

    dependencies = [
        ('resources', '0008_resource_shortened_file_url'),
        ('courses', '0027_auto_20190318_1047'),
    ]

    operations = [
        migrations.AddField(
            model_name='course',
            name='journal_resource',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='resources.Resource', verbose_name='\u0424\u0430\u0439\u043b \u0441 \u0436\u0443\u0440\u043d\u0430\u043b\u043e\u043c'),
        ),
        migrations.RunPython(
            transform_journal_to_journal_resource('Course'),
            reverse_code=transform_journal_resource_to_journal('Course'),
        ),
        migrations.AddField(
            model_name='courselessonlink',
            name='journal_resource',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='resources.Resource',
                                    verbose_name='\u0424\u0430\u0439\u043b \u0441 \u0436\u0443\u0440\u043d\u0430\u043b\u043e\u043c'),
        ),
        migrations.RunPython(
            transform_journal_to_journal_resource('CourseLessonLink'),
            reverse_code=transform_journal_resource_to_journal('CourseLessonLink'),
        ),
    ]
