# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2020-06-08 12:24
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0046_auto_20200604_1911'),
    ]

    operations = [
        migrations.CreateModel(
            name='CourseInvite',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('max_attempts', models.IntegerField(blank=True, help_text='Лимит подключений, NULL - без лимита', null=True, verbose_name='Лимит подключений')),
                ('start_at', models.DateTimeField(blank=True, help_text='Дата начала доступности, NULL - неограничено', null=True, verbose_name='Дата начала доступности')),
                ('expire_at', models.DateTimeField(blank=True, help_text='Дата протухания, NULL - неограничено', null=True, verbose_name='Дата протухания')),
                ('is_active', models.BooleanField(verbose_name='Инвайт активен')),
                ('key', models.CharField(db_index=True, max_length=32, unique=True, verbose_name='Код активации')),
                ('course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='courses.Course', verbose_name='Курс')),
            ],
            options={
                'verbose_name': 'Инвайт в курс',
                'verbose_name_plural': 'Инвайты в курсы',
            },
        ),
        migrations.CreateModel(
            name='UserCourseInviteActivation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('course_invite', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='courses.CourseInvite', verbose_name='Активированный инвайт')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL, verbose_name='Пользователь')),
            ],
            options={
                'verbose_name': 'Активация инвайта в курс',
                'verbose_name_plural': 'Активации инвайтов в курсы',
            },
        ),
        migrations.AlterUniqueTogether(
            name='usercourseinviteactivation',
            unique_together=set([('course_invite', 'user')]),
        ),
    ]
