# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations
from django_bulk_update.helper import bulk_update

BULK_BATCH_SIZE_DEFAULT = 1000


def migrate_achievery_level(apps, schema_editor):
    Criterion = apps.get_model('courses', 'Criterion')
    criteria_to_update = []
    for criterion in Criterion.objects.all():
        change_criterion = False
        for action in criterion.actions or []:
            if (
                isinstance(action, dict) and
                action.get('type') in ('REQUEST_ACHIEVEMENT_ACTION', 'REQUEST_TEAM_ACHIEVEMENT_ACTION') and
                'level' in action and
                str(action['level']) == '-1'
            ):
                action['level'] = 0
                change_criterion = True

        if change_criterion:
            criteria_to_update.append(criterion)

    bulk_update(
        objs=criteria_to_update,
        batch_size=BULK_BATCH_SIZE_DEFAULT,
    )


def migrate_achievery_level_reverse(apps, schema_editor):
    Criterion = apps.get_model('courses', 'Criterion')
    criteria_to_update = []
    for criterion in Criterion.objects.all():
        change_criterion = False
        for action in criterion.actions or []:
            if (
                isinstance(action, dict) and
                action.get('type') in ('REQUEST_ACHIEVEMENT_ACTION', 'REQUEST_TEAM_ACHIEVEMENT_ACTION') and
                'level' in action and
                str(action['level']) == '0'
            ):
                action['level'] = -1
                change_criterion = True

        if change_criterion:
            criteria_to_update.append(criterion)

    bulk_update(
        objs=criteria_to_update,
        batch_size=BULK_BATCH_SIZE_DEFAULT,
    )


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0052_auto_20201008_0512'),
    ]

    operations = [
        migrations.RunPython(
            migrate_achievery_level,
            migrate_achievery_level_reverse,
        ),
    ]
