# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-10-10 23:48
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import kelvin.common.fields
import kelvin.common.serializers


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0055_coursestudent_completed'),
    ]

    operations = [
        migrations.CreateModel(
            name='PeriodicCourse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('period', models.PositiveSmallIntegerField(default=365, help_text='период зачисления на курс, в днях', validators=[django.core.validators.MinValueValidator(1)], verbose_name='период')),
                ('course', models.OneToOneField(on_delete=django.db.models.deletion.PROTECT, related_name='periodic', to='courses.Course', verbose_name='Текущий курс')),
                ('previous', models.ManyToManyField(blank=True, to='courses.Course', verbose_name='прошедшие курсы')),
            ],
            options={
                'verbose_name': 'периодический курс',
                'verbose_name_plural': 'периодические курсы',
            },
        ),
        migrations.CreateModel(
            name='PeriodicNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('notify_type', models.CharField(choices=[('email', 'Почта'), ('tracker', 'Тикет в Трекере')], default='email', max_length=20, verbose_name='тип уведомления')),
                ('delay', models.PositiveSmallIntegerField(default=0, help_text='период в днях между зачислением на курс и отправкой уведомления', verbose_name='кол-во дней до уведомления')),
                ('parameters', kelvin.common.fields.JSONField(default=dict, encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='параметры')),
                ('periodic_course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to='courses.PeriodicCourse', verbose_name='курс')),
            ],
            options={
                'verbose_name': 'настройка уведомлений',
                'verbose_name_plural': 'настройки уведомлений',
                'ordering': ('periodic_course', 'delay'),
            },
        ),
        migrations.CreateModel(
            name='PeriodicStudentNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('course', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='periodic_student_notifications', to='courses.Course', verbose_name='курс')),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='notified', to='courses.PeriodicNotification', verbose_name='уведомление')),
                ('student', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='periodic_notifications', to='courses.CourseStudent', verbose_name='студент')),
                ('status', models.CharField(choices=[('pending', 'Ожидает'), ('sent', 'Отправлено'), ('error', 'Ошибка')], default='pending', max_length=20, verbose_name='статус')),
                ('errors', models.TextField(blank=True, verbose_name='сообщения об ошибках')),
            ],
            options={
                'verbose_name': 'отправленное уведомление по периодическому курсу',
                'verbose_name_plural': 'отправленные уведомления по периодическим курсам',
            },
        ),
    ]
