# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-11-10 22:41
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('courses', '0056_periodic_courses'),
    ]

    operations = [
        migrations.CreateModel(
            name='ExcludedUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('login', models.CharField(max_length=255, verbose_name='логин')),
                ('exclude_from_courses', models.BooleanField(default=True, verbose_name='не зачислять в курсы')),
                ('exclude_from_issues', models.BooleanField(default=True, verbose_name='не создавать тикеты')),
            ],
            options={
                'verbose_name': 'пользователь, исключенный из периодических курсов',
                'verbose_name_plural': 'пользователи, исключенные из периодических курсов',
            },
        ),
        migrations.CreateModel(
            name='NotifyDayOff',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('name', models.CharField(blank=True, max_length=255, verbose_name='название')),
                ('comments', models.TextField(blank=True, verbose_name='комментарии')),
                ('day', models.PositiveSmallIntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(31)], verbose_name='день')),
                ('month', models.PositiveSmallIntegerField(validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(12)], verbose_name='месяц')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('valid_from', models.DateTimeField(verbose_name='действует с')),
                ('valid_to', models.DateTimeField(blank=True, null=True, verbose_name='действует до')),
            ],
            options={
                'verbose_name': 'исключение для уведомлений',
                'verbose_name_plural': 'исключения для уведомлений',
            },
        ),
        migrations.AddField(
            model_name='periodicnotification',
            name='priority',
            field=models.PositiveSmallIntegerField(default=0, help_text='уведомления будут отправляться с учетом приоритета, от большего к меньшему', verbose_name='приоритет'),
        ),
    ]
