# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-11-30 15:09
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import kelvin.common.fields
import kelvin.common.serializers


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0058_periodic_student_notification_resuls_data'),
    ]

    operations = [
        migrations.CreateModel(
            name='PeriodicRoleDigest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('first_run', models.DateField(db_index=True, help_text='дата, с которой запускаются проверки на формирование дайджеста', verbose_name='дата первого запуска дайджеста')),
                ('is_active', models.BooleanField(default=True, verbose_name='активен')),
                ('interval', models.PositiveSmallIntegerField(help_text='дайджесты не формируются чаще, чем этот интервал', validators=[django.core.validators.MinValueValidator(1)], verbose_name='минимальный интервал между дайджестами')),
                ('role', models.CharField(choices=[('chief', 'руководитель'), ('hrbp', 'hr-партнер')], db_index=True, max_length=10, verbose_name='тип дайджеста')),
                ('delay', models.PositiveSmallIntegerField(help_text='период (в днях) между датой назначения курса и попаданием в дайджест руководителю', validators=[django.core.validators.MinValueValidator(1)], verbose_name='период до попадания в дайджест')),
                ('can_reopen_issue', models.BooleanField(default=False, help_text='для нового дайджеста переоткрывается старый тикет (иначе создается новый)', verbose_name='переоткрывать тикет для нового дайджеста')),
                ('parameters', kelvin.common.fields.JSONField(default=dict, encoder=kelvin.common.serializers.CustomDjangoJSONEncoder, verbose_name='параметры')),
                ('periodic_course', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='role_digests', to='courses.PeriodicCourse', verbose_name='периодический курс')),
            ],
            options={
                'verbose_name': 'периодический дайджест',
                'verbose_name_plural': 'периодические дайджесты',
            },
        ),
        migrations.CreateModel(
            name='RoleDigest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('date_created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(auto_now=True, verbose_name='Date of change')),
                ('tracker_issue_key', models.CharField(blank=True, db_index=True, help_text='ключ тикета в трекере', max_length=255, verbose_name='ключ тикета')),
                ('target_issue_status', models.CharField(help_text='статус тикета в трекере, который нужно установить', max_length=100, verbose_name='статус тикета')),
                ('process_status', models.CharField(choices=[('pending', 'обрабатывается'), ('done', 'создан'), ('error', 'ошибка')], default='pending', max_length=10, verbose_name='статус обработки тикета')),
                ('errors', models.TextField(blank=True, verbose_name='сообщения об ошибках')),
                ('periodic_role_digest', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='digests', to='courses.PeriodicRoleDigest', verbose_name='периодический дайджест')),
                ('user', models.ForeignKey(help_text='пользователь, для которого создается дайджест', on_delete=django.db.models.deletion.CASCADE, related_name='digests', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'дайджест для сотрудника',
                'verbose_name_plural': 'дайджесты для сотрудников',
            },
        ),
    ]
