# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-12-08 12:53
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('courses', '0059_role_digest'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalRoleDigest',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date_created', models.DateTimeField(blank=True, editable=False, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(blank=True, editable=False, verbose_name='Date of change')),
                ('tracker_issue_key', models.CharField(blank=True, db_index=True, help_text='ключ тикета в трекере', max_length=255, verbose_name='ключ тикета')),
                ('target_issue_status', models.CharField(help_text='статус тикета в трекере, который нужно установить', max_length=100, verbose_name='статус тикета')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
                ('periodic_role_digest', models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='courses.PeriodicRoleDigest', verbose_name='периодический дайджест')),
                ('user', models.ForeignKey(blank=True, db_constraint=False, help_text='пользователь, для которого создается дайджест', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to=settings.AUTH_USER_MODEL, verbose_name='пользователь')),
            ],
            options={
                'verbose_name': 'historical дайджест для сотрудника',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AlterField(
            model_name='notifydayoff',
            name='valid_from',
            field=models.DateTimeField(default=django.utils.timezone.now, verbose_name='действует с'),
        ),
    ]
