from builtins import object, range

from past.utils import old_div

from django.db import models, transaction
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

from kelvin.common.model_mixins import TimeStampMixin

from .course import Course


@python_2_unicode_compatible
class CourseFeedback(TimeStampMixin):
    MIN_SCORE = 1
    MAX_SCORE = 5

    course = models.ForeignKey(
        to='courses.Course',
        verbose_name=_('Курс'),
        related_name='feedback_set',
    )

    user = models.ForeignKey(
        to='accounts.User',
        verbose_name=_('Пользователь'),
    )

    score = models.PositiveSmallIntegerField(
        verbose_name=_('Оценка'),
        choices=((i, i) for i in range(MIN_SCORE, MAX_SCORE + 1))
    )

    comment = models.TextField(
        verbose_name=_('Комментарий'),
        max_length=4096,
        blank=True,
    )

    def __str__(self):
        return "Курс: {} Пользователь: {} Оценка: {}".format(
            self.course.id,
            self.user.id,
            self.score,
        )

    class Meta(object):
        verbose_name = _('Оценка курса')
        verbose_name_plural = _('Оценки курсов')
        unique_together = ('course', 'user',)
