from builtins import object

from model_utils.models import TimeStampedModel

from django.db import models
from django.utils.translation import ugettext_lazy as _

from kelvin.common.model_mixins import UserBlameMixin


class CourseTVMService(TimeStampedModel, UserBlameMixin, models.Model):
    course = models.ForeignKey(
        to='courses.Course',
        verbose_name=_('Курс'),
        on_delete=models.CASCADE,
    )
    tvm_service = models.ForeignKey(
        to='tvm.TVMService',
        verbose_name=_('TVM-сервис'),
    )

    def __str__(self):
        return 'Course {}, tvm_service: {}'.format(self.course.id, self.tvm_service)

    class Meta(object):
        verbose_name = _('Доуступ к курсу по TVM')
        verbose_name_plural = _('Доступы к курсам по TVM')
        unique_together = ('course', 'tvm_service')
