from uuid import uuid4

from django.conf import settings
from django.db import models
from django.utils.translation import gettext_lazy as _


class CourseInvite(models.Model):
    course = models.ForeignKey(to='courses.Course', verbose_name=_('Курс'))
    max_attempts = models.IntegerField(
        null=True,
        blank=True,
        verbose_name=_('Лимит подключений'),
        help_text=_("Лимит подключений, NULL - без лимита")
    )
    start_at = models.DateTimeField(
        null=True,
        blank=True,
        verbose_name=_('Дата начала доступности'),
        help_text=_("Дата начала доступности, NULL - неограничено")
    )
    expire_at = models.DateTimeField(
        null=True,
        blank=True,
        verbose_name=_('Дата протухания'),
        help_text=_("Дата протухания, NULL - неограничено")
    )
    is_active = models.BooleanField(verbose_name=_('Инвайт активен'))
    key = models.CharField(max_length=32, db_index=True, unique=True, verbose_name=_("Код активации"))

    @property
    def activations(self):
        return self.usercourseinviteactivation_set.count()

    @property
    def activation_link(self):
        if self.key:
            return f'{settings.FRONTEND_HOST}courses/invite/{self.key}'
        else:
            return ''

    def save(self, *args, **kwargs):
        if not self.key:
            self.key = uuid4().hex
        return super().save(*args, **kwargs)

    def __str__(self):
        return f'Invite {self.key}'

    class Meta(object):
        verbose_name = _('Инвайт в курс')
        verbose_name_plural = _('Инвайты в курсы')
