from model_utils.models import TimeStampedModel

from django.contrib.auth import get_user_model
from django.db import models
from django.utils.translation import gettext_lazy as _

User = get_user_model()


class UserCourseInviteActivation(TimeStampedModel, models.Model):
    course_invite = models.ForeignKey(to='courses.CourseInvite', verbose_name=_('Активированный инвайт'))
    user = models.ForeignKey(to=User, verbose_name=_('Пользователь'))

    def __str__(self):
        return f'User: {self.user} | {self.course_invite}'

    class Meta(object):
        verbose_name = _('Активация инвайта в курс')
        verbose_name_plural = _('Активации инвайтов в курсы')
        unique_together = ('course_invite', 'user')
