from builtins import object

from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

from kelvin.common.fields import JSONField

from ..validators import validate_progress_indicator_palette


@python_2_unicode_compatible
class ProgressIndicator(models.Model):
    """
    Индикатор прогресса
    """
    slug = models.CharField(
        unique=True,
        max_length=255,
    )
    palette = JSONField(
        verbose_name=_('Палитра прогрессбара'),
        validators=[validate_progress_indicator_palette],
    )

    def __str__(self):
        return 'Индикатор {}, id {}'.format(self.slug, self.pk)

    class Meta(object):
        verbose_name = _('Индикатор прогресса')
        verbose_name_plural = _('Индикаторы прогресса')
