from builtins import object

from rest_framework import serializers

from ..models import CourseLessonLink


class CLessonInProjectSerializer(serializers.ModelSerializer):
    """
    Сериализатор КурсоУрока для показа в проектах
    """

    name = serializers.CharField(source='lesson.name')
    date_assignment_passed = serializers.BooleanField()

    class Meta(object):
        model = CourseLessonLink
        fields = (
            'id',
            'order',
            'name',
            'date_assignment_passed',
        )
