from builtins import object

from rest_framework import serializers

from kelvin.courses.models import Course
from kelvin.resources.serializers import ResourceSerializerCorp as ResourceSerializer


class CourseDetailApiSerializer(serializers.ModelSerializer):
    """
    Сериализатор информации о курсе для API LK
    """
    cover = ResourceSerializer(read_only=True)
    subject = serializers.CharField(source='subject.slug')
    subject_name = serializers.CharField(source='subject.name')

    class Meta(object):
        model = Course
        fields = (
            'id',
            'name',
            'description',
            'color',
            'cover',
            'date_updated',
            'date_closed',
            'subject',
            'subject_name',
            'info',
            'news',
        )
