from builtins import object

from django.db.models import Sum
from django.db.models.functions import Coalesce

from rest_framework import serializers

from kelvin.courses.models import CourseLessonLink
from kelvin.results.models import CourseLessonResult
from kelvin.sapi.serializers import CourseDetailClessonProblemsSerializer


class CourseDetailClessonsSerializer(serializers.ModelSerializer):
    """
    Сериализатор информации об уроке
    """
    problems_count = serializers.IntegerField(source='lesson.problems.count')
    problems = CourseDetailClessonProblemsSerializer(
        source='lesson.problems',
        many=True,
        required=False,
        read_only=True,
    )
    points = serializers.SerializerMethodField()

    class Meta(object):
        model = CourseLessonLink
        fields = (
            'id',
            'problems_count',
            'points',
            'problems',
        )

    @staticmethod
    def get_points(clesson):
        return CourseLessonResult.objects.filter(
            summary__clesson=clesson
        ).aggregate(
            max=Coalesce(Sum('max_points'), 0),
            total=Coalesce(Sum('points'), 0)
        )
