from rest_framework import serializers

from kelvin.courses.models import CourseFeedback


class CourseFeedbackSerializer(serializers.Serializer):
    score = serializers.IntegerField(min_value=1, max_value=5)
    comment = serializers.CharField(max_length=4096, required=False)

    def create(self, validated_data):
        return CourseFeedback.objects.create(**validated_data)

    def update(self, feedback, validated_data):
        feedback.score = validated_data.get('score', feedback.score)
        feedback.comment = validated_data.get('comment', '')
        feedback.save()

        return feedback
