from builtins import object

from rest_framework import serializers

from ..models import Course


class CourseInEventSerializer(serializers.ModelSerializer):
    """
    Сериализатор курса в мероприятии
    """
    subject = serializers.CharField(source='subject.slug')

    class Meta(object):
        model = Course
        fields = (
            'id',
            'name',
            'code',
            'subject',
        )
        read_only_fields = (
            'id',
            'name',
            'code',
            'subject',
        )
