from builtins import object

from rest_framework import serializers

from kelvin.group_levels.serializers import GroupLevelSerializer

from ..models import Course


class CourseInPageSerializer(serializers.ModelSerializer):
    """
    Сериализатор курса для статической страницы
    """
    group_levels = GroupLevelSerializer(many=True)
    paid = serializers.SerializerMethodField()

    def get_paid(self, course):
        """
        Оплачен ли курс пользователем

        Берет из контекста информацию об оплаченности курса
        """
        return course.id in self.context.get('paid_courses', set())

    class Meta(object):
        model = Course
        fields = (
            'id',
            'group_levels',
            'paid',
        )
