from builtins import object

from rest_framework import serializers

from ..models import Course
from .clesson_in_project import CLessonInProjectSerializer


class CourseInProjectShortSerializer(serializers.ModelSerializer):
    """
    Сериализатор для модели курса для показа в проектах
    """
    class Meta(object):
        model = Course
        fields = (
            'id',
            'name',
        )


class CourseInProjectExtendedSerializer(CourseInProjectShortSerializer):
    """
    Сериализатор для модели курса для показа в проектах
    """

    clessons = CLessonInProjectSerializer(
        source='courselessonlink_set',
        many=True,
    )

    class Meta(CourseInProjectShortSerializer.Meta):
        fields = CourseInProjectShortSerializer.Meta.fields + ('clessons', )
