from builtins import object

from rest_framework import serializers

from kelvin.courses.models import CourseLessonLink


class CourseLessonsListSerializer(serializers.ModelSerializer):
    """
    Сериализатор списка курсозанятий для API

    /api/v2/sirius-courses/<pk>/
    """
    name = serializers.CharField(source='lesson.name')

    class Meta(object):
        model = CourseLessonLink
        fields = (
            'id',
            'name',
            'lesson',
            'mode',
            'duration',
            'max_attempts_in_group',
            'show_answers_in_last_attempt',
            'show_all_problems',
            'accessible_to_teacher',
            'date_assignment',
            'date_completed',
            'date_updated',
            'url',
            'start_date',
            'comment',
        )
        read_only_fields = (
            'id',
            'accessible_to_teacher',
            'date_updated',
            'date_completed',
        )
