from builtins import object

from rest_framework import serializers

from kelvin.courses.models import Course


class CourseNameSerializer(serializers.ModelSerializer):
    """
    Сериализатор модели `Course` только с именем курса
    """

    def to_internal_value(self, data):
        """ Десериализация в объект """
        try:
            return Course.objects.get(id=data.get('id'))
        except (ValueError, TypeError, Course.DoesNotExist):
            raise serializers.ValidationError(
                u'Некорректный идентификатор курса'
            )

    class Meta(object):
        model = Course
        fields = ('id', 'name')
        read_only_fields = (
            'name',
        )
