from builtins import object

from rest_framework import serializers

from kelvin.accounts.serializers import UserSerializer
from kelvin.courses.models import CoursePermission


class CoursePermissionSerializer(serializers.ModelSerializer):

    roles = serializers.SerializerMethodField()
    user = UserSerializer(read_only=True)

    def get_roles(self, course_permission):
        roles = []
        if course_permission.is_owner:
            roles.append('owner')
        if course_permission.is_content_manager:
            roles.append('content_manager')
        if course_permission.is_analyst:
            roles.append('analyst')
        if course_permission.is_curator:
            roles.append('curator')

        return roles

    class Meta(object):
        model = CoursePermission
        read_only_fields = (
            'roles',
            'user',
        )
        fields = read_only_fields
