from builtins import object

from rest_framework import serializers

from kelvin.accounts.models import User


class TotalResultSerializer(serializers.Serializer):
    points = serializers.FloatField()
    max_points = serializers.FloatField()
    percent = serializers.SerializerMethodField()

    def get_percent(self, obj):
        points = obj['points']
        max_points = obj['max_points']
        return float(points) / max_points * 100 if max_points != 0 else 0.

    class Meta(object):
        fields = (
            'points',
            'max_points',
            'percent',
        )


class ResultSerializer(TotalResultSerializer):
    last_modified = serializers.DateTimeField()

    class Meta(TotalResultSerializer.Meta):
        fields = TotalResultSerializer.Meta.fields + (
            'last_modified',
        )


class ClessonResultSerializer(serializers.Serializer):
    clesson_id = serializers.IntegerField()
    result = ResultSerializer()

    class Meta(object):
        fields = ('clesson_id', 'result')


class UserWithResultsSerializer(serializers.ModelSerializer):
    total_result = TotalResultSerializer()
    clessons = ClessonResultSerializer(many=True)
    login = serializers.CharField(source='username')

    class Meta(object):
        model = User
        fields = ('login', 'total_result', 'clessons')
