from builtins import object

from rest_framework import serializers

from kelvin.courses.models import Course
from kelvin.courses.serializers.sirius_course_lesson_with_result_api import SiriusCourseLessonWithResultApiSerializer
from kelvin.resources.serializers import BaseResourceSerializer as ResourceSerializer


class CoursesAssignedToApiSerializer(serializers.ModelSerializer):
    """
    Сериализатор назначенных пользователю курсов и курсозанятий
    для API (без результатов)
    """
    cover = ResourceSerializer(read_only=True)
    subject = serializers.CharField(source='subject.slug')
    subject_name = serializers.CharField(source='subject.name')
    clessons = serializers.SerializerMethodField()

    class Meta(object):
        model = Course
        fields = (
            'id',
            'name',
            'description',
            'color',
            'cover',
            'date_updated',
            'date_closed',
            'subject',
            'subject_name',
            'info',
            'clessons',
        )
        read_only_fields = (
            'id',
            'name',
            'description',
            'color',
            'cover',
            'date_updated',
            'date_closed',
            'subject',
            'subject_name',
            'info',
            'clessons',
        )

    def get_courses_list(self, c):
        return self._courses_list

    def get_clessons(self, course):
        """
        Возвращает список курсозанятий
        """
        qs = course.courselessonlink_set.all().prefetch_related('lesson')
        return SiriusCourseLessonWithResultApiSerializer(qs, context={
            'user_id': self.context.get('user_id')
        }, many=True).data
