from builtins import object

from django.conf import settings
from rest_framework import serializers

from kelvin.courses.models import Course
from kelvin.resources.serializers import ResourceSerializerCorp as ResourceSerializer


class CourseIndexSerializer(serializers.ModelSerializer):
    """
    Сериализатор списка курсов для индексации внутренним поиском
    """
    created = serializers.DateTimeField(source='date_created')
    updated = serializers.DateTimeField(source='date_updated')
    name = serializers.SerializerMethodField()
    content = serializers.SerializerMethodField()
    subject = serializers.SerializerMethodField()
    url = serializers.SerializerMethodField()
    api_url = serializers.SerializerMethodField()
    cover = ResourceSerializer(read_only=True)
    average_score = serializers.DecimalField(
        decimal_places=1,
        max_digits=2,
    )

    def get_name(self, obj):
        return {
            'ru': obj.name,
            'language': 'ru',
        }

    def get_content(self, obj):
        return {
            'ru': obj.description,
            'language': 'ru',
        }

    def get_subject(self, obj):
        return {
            'ru': obj.subject.name,
            'language': 'ru',
        }

    def get_url(self, obj):
        return f'{settings.FRONTEND_HOST}courses/library/course/{obj.pk}'

    def get_api_url(self, obj):
        request = self.context['request']

        current_uri = f'{request.scheme}://{request.get_host()}'
        path = f'/api/v3/sirius-courses/{obj.pk}/index_detail/'

        return f'{current_uri}{path}'

    class Meta(object):
        model = Course
        fields = (
            'id',
            'created',
            'updated',
            'name',
            'content',
            'subject',
            'url',
            'api_url',
            'cover',
            'average_score',
        )
        read_only_fields = fields
