from builtins import object

from rest_framework import serializers

from kelvin.courses.models import Course, CourseFeedback
from kelvin.resources.serializers import ResourceSerializerCorp as ResourceSerializer


class FeedbackSerializer(serializers.ModelSerializer):
    class Meta:
        model = CourseFeedback
        fields = ('score', 'comment')


class CoursesLibrarySerializer(serializers.ModelSerializer):
    """
    Сериализатор списка курсов для библиотеки
    """
    cover = ResourceSerializer(read_only=True)
    subject = serializers.CharField(source='subject.slug')
    subject_name = serializers.CharField(source='subject.name')
    average_score = serializers.DecimalField(
        decimal_places=1,
        max_digits=2,
    )
    feedback = serializers.SerializerMethodField()

    def get_feedback(self, course):
        feedback = course.feedback_set.all()
        for feedback_item in feedback:
            return FeedbackSerializer(feedback_item).data
        return {}

    class Meta(object):
        model = Course
        fields = (
            'id',
            'name',
            'code',
            'date_updated',
            'description',
            'cover',
            'subject',
            'subject_name',
            'average_score',
            'feedback',
        )
        read_only_fields = (
            'id',
            'name',
            'code',
            'date_updated',
            'description',
            'cover',
            'subject',
            'subject_name',
            'average_score',
            'feedback',
        )
