from builtins import object

from rest_framework import serializers

from kelvin.courses.models import Course
from kelvin.resources.serializers import ResourceSerializerCorp as ResourceSerializer


class CoursesShortListSerializer(serializers.ModelSerializer):
    cover = ResourceSerializer(read_only=True)

    class Meta(object):
        model = Course
        fields = ('id', 'name', 'cover', 'description')

        read_only_fields = ('cover',)
