from builtins import object

from rest_framework import serializers

from kelvin.courses.models import CourseLessonLink


class SiriusCourseLessonWithResultApiSerializer(serializers.ModelSerializer):
    """
    Сериализатор курсозанятий с без результатов для API
    """

    lesson_id = serializers.IntegerField(source='lesson.id')
    name = serializers.CharField(source='lesson.name')

    class Meta(object):
        model = CourseLessonLink
        fields = (
            'id',
            'lesson_id',
            'name',
            'date_assignment',
            'date_completed',
            'finish_date',
            'evaluation_date',
            'start_date',
            'mode',
            'duration',
            'comment',
        )
