from django.template import Context, Template, loader
from django.utils.functional import cached_property


def render_string(template_string: str, ctx: dict) -> str:
    context = Context(ctx)
    data = Template(template_string).render(context)
    return str(data).strip()


class TrackerTemplateBase:
    summary_template = ''
    description_template = ''
    open_comment_template = ''
    close_comment_template = ''

    def get_ctx(self) -> dict:
        raise NotImplementedError

    @cached_property
    def context(self) -> dict:
        return self.get_ctx()

    def get_fields(self) -> dict:
        raise NotImplementedError

    def get_description(self) -> str:
        return loader.render_to_string(
            template_name=self.description_template,
            context=self.context,
        )

    def get_summary(self) -> str:
        return loader.render_to_string(
            template_name=self.summary_template,
            context=self.context,
        )

    def get_open_comment(self) -> str:
        return loader.render_to_string(
            template_name=self.open_comment_template,
            context=self.context,
        )

    def get_close_comment(self) -> str:
        return loader.render_to_string(
            template_name=self.close_comment_template,
            context=self.context,
        )

    def as_dict(self) -> dict:
        return {
            **self.get_fields(),
            **{'summary': self.get_summary(), 'description': self.get_description()},
        }
