from django.apps import apps  # to avoid cicular imports  ( INTLMS-497 )
from django.contrib.contenttypes.models import ContentType
from django.db import transaction

from kelvin.courses.models import CourseStudent
from kelvin.lesson_assignments.models import LessonAssignment


def get_course_projects(course):
    tag_model = apps.get_model('tags', 'Tag')
    tagged_object_model = apps.get_model('tags', 'TaggedObject')
    course_model = apps.get_model('courses', 'Course')
    return [
        int(x.tag.value) for x in tagged_object_model.objects.filter(
            object_id=course.id,
            content_type=ContentType.objects.get_for_model(course_model),
            tag__type=tag_model.PROJECT,
        )
    ]


def save_course_in_project(course, project_id):
    tag_model = apps.get_model('tags', 'Tag')
    tagged_object_model = apps.get_model('tags', 'TaggedObject')
    course_model = apps.get_model('courses', 'Course')
    project_tag = tag_model.objects.filter(
        type=tag_model.PROJECT,
        value=project_id,
    ).first()
    course_project_tagging_object = tagged_object_model(
        tag=project_tag,
        content_type=ContentType.objects.get_for_model(course_model),
        object_id=course.id,
        content_object=course,
    )
    course_project_tagging_object.save()


@transaction.atomic
def add_courses_to_user(courses, user):
    for course in courses:
        CourseStudent.objects.update_or_create(
            student=user,
            course=course,
            defaults={
                'deleted': False,
            }
        )
        LessonAssignment.ensure_student_assignments(course, user)
