from django_filters.rest_framework import DjangoFilterBackend

from rest_framework import filters

from kelvin.courses.views.course.course import CourseViewSet
from kelvin.sapi.pagination import SiriusApiPaginator


class CourseViewSet3(CourseViewSet):
    filter_backends = [filters.SearchFilter, DjangoFilterBackend]
    search_fields = ['name', 'code']
    filter_fields = [
        'name', 'code', 'score_count', 'project', 'subject', 'mode',
        'owner', 'author', 'color', 'copy_of', 'free', 'date_closed',
    ]
    pagination_class = SiriusApiPaginator
