from django.conf import settings

from rest_framework.mixins import ListModelMixin
from rest_framework.viewsets import GenericViewSet

from kelvin.courses.models import CourseStudent
from kelvin.courses.serializers.course_student_username import CourseStudentUsernameSerializer

from ..permissions import course_tvmservice_permission_factory

CourseTVMServicePermission = course_tvmservice_permission_factory()


class CourseStudentsViewSet(ListModelMixin, GenericViewSet):

    authentication_classes = []
    queryset = CourseStudent.objects.all()
    serializer_class = CourseStudentUsernameSerializer

    permission_classes = [
        CourseTVMServicePermission
    ]

    def get_queryset(self, *args, **kwargs):
        filters = {}
        filters['course_id'] = self.kwargs['course_pk']
        logins = self.request.query_params.getlist('login')
        if logins:
            filters['student__username__in'] = logins

        return (
            super(CourseStudentsViewSet, self)
            .get_queryset(*args, **kwargs)
            .filter(**filters)
            .order_by('id')
            .only('student__username')
        )
