from rest_condition import Or

from rest_framework import mixins, viewsets
from rest_framework.permissions import IsAuthenticated

from kelvin.accounts.permissions import IsContentManager, IsParent, IsStaff, IsTeacher
from kelvin.courses.filters import SourceCourseProjectFilter
from kelvin.courses.models import Course
from kelvin.courses.serializers import SourceCourseSerializer
from kelvin.switcher import get_feature_bool_option


class SourceCourseViewSet(mixins.RetrieveModelMixin,
                          mixins.ListModelMixin,
                          viewsets.GenericViewSet):
    """
    API для получения курсов-источников
    """
    @staticmethod
    def _get_filter_class():
        return SourceCourseProjectFilter

    def get_queryset(self):
        queryset = (
            Course.objects.all().select_related('cover')
        )
        if get_feature_bool_option('E7N_ENABLE_NEW_COURSE_PERMISSIONS', False) and not self.request.user.is_superuser:
            queryset = queryset.filter(
                coursepermission__user=self.request.user,
                coursepermission__permission__gt=0
            )
        return queryset

    serializer_class = SourceCourseSerializer
    permission_classes = [
        IsAuthenticated,
        Or(IsTeacher, IsContentManager, IsStaff, IsParent)
    ]

    filter_class = _get_filter_class.__func__()
