from builtins import object

from django.db import models
from django.utils.translation import ugettext_lazy as _

from kelvin.common.model_mixins import TimeStampMixin
from kelvin.common.utils import safe_filename


def formula_upload_path(instance, filename):
    """
    Возвращает путь и имя файла для сохранения ресурса
    """
    return safe_filename(filename, 'formulas')


class ConvertedFormula(TimeStampMixin, models.Model):
    """
    Сконвертированные формулы
    """
    code = models.TextField(
        _('Формула в TEX-e'),
        db_index=True,
    )
    style = models.TextField(
        _('CSS-стили'),
        default='',
    )
    image = models.ImageField(
        verbose_name=_('Картинка со сгенерированной формулой'),
        upload_to=formula_upload_path,
        max_length=255,
    )

    class Meta(object):
        verbose_name = _('Формула')
        verbose_name_plural = _('Формулы')
