from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

# справочник надгрупп ученических групп
BASELEVEL_CHOICES = (
    (1, _('Детский сад')),
    (2, _('Школа')),
)


@python_2_unicode_compatible
class GroupLevel(models.Model):
    """
    Уровень группы учеников
    """
    name = models.CharField(
        verbose_name=_('Название уровня'),
        max_length=255,
    )
    baselevel = models.SmallIntegerField(
        verbose_name=_('Код базового уровня (надуровня)'),
        choices=BASELEVEL_CHOICES,
    )
    slug = models.SlugField(
        verbose_name=_('Слаг'),
        unique=True,
    )

    def __str__(self):
        """
        Название уровня
        """
        return '{0} ({1})'.format(self.name, self.get_baselevel_display())
