from rest_framework import serializers


class BaselevelField(serializers.Field):
    """
    Сериализатор для поля базового уровня
    """
    def to_representation(self, level):
        """
        Добавляем имя базового уровня
        """
        return {
            'id': level.baselevel,
            'name': level.get_baselevel_display(),
            'slug': level.slug,
        }
