from builtins import object

from rest_framework import serializers

from kelvin.common.serializer_fields import NestedManyToManyField
from kelvin.group_levels.models import GroupLevel
from kelvin.group_levels.serializer_fields import BaselevelField


class GroupLevelSerializer(serializers.ModelSerializer):
    """
    Сериализатор уровня группы учеников
    """
    baselevel = BaselevelField(source='*')

    class Meta(object):
        model = GroupLevel
        fields = '__all__'


class GroupLevelBasicSerializer(serializers.ModelSerializer):
    """
    Сериализатор уровня группы учеников без раскрытия базового уровня
    """
    class Meta(object):
        model = GroupLevel
        fields = '__all__'


class GroupLevelListField(NestedManyToManyField):
    """
    Поле сериализатора для списка уровней группы
    """
    class Meta(object):
        model = GroupLevel
        serializer = GroupLevelBasicSerializer
