from django.db import migrations, models
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('group_levels', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Group',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=255, verbose_name='\u041d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b')),
                ('code', models.CharField(unique=True, max_length=15, verbose_name='\u041a\u043e\u0434 \u0433\u0440\u0443\u043f\u043f\u044b', blank=True)),
                ('cover', models.FileField(upload_to='group_cover', verbose_name='\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0430 \u0433\u0440\u0443\u043f\u043f\u044b', blank=True)),
                ('level', models.ForeignKey(verbose_name='\u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0433\u0440\u0443\u043f\u043f\u044b', blank=True, to='group_levels.GroupLevel', null=True)),
                ('owner', models.ForeignKey(related_name='owned_groups', verbose_name='\u0421\u043e\u0437\u0434\u0430\u0442\u0435\u043b\u044c \u0433\u0440\u0443\u043f\u043f\u044b', to=settings.AUTH_USER_MODEL)),
                ('students', models.ManyToManyField(related_name='student_in_groups', verbose_name='\u0423\u0447\u0435\u043d\u0438\u043a\u0438 \u0433\u0440\u0443\u043f\u043f\u044b', to=settings.AUTH_USER_MODEL, blank=True)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
    ]
