from model_utils.models import TimeStampedModel

from django.conf import settings
from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _

from kelvin.common.fields import JSONField


@python_2_unicode_compatible
class UserIDMRoleRequest(TimeStampedModel, models.Model):
    user = models.ForeignKey(to=settings.AUTH_USER_MODEL, verbose_name=_('пользователь'))
    system = models.CharField(max_length=255, verbose_name=_('Slug системы'))
    path = models.CharField(
        max_length=1024,
        verbose_name=_('Идентификатор роли в дереве ролей'),
        help_text='/full/path/example/',
    )
    fields_data = JSONField(
        verbose_name=_('Дополнительные поля'),
        blank=True,
        default={},
    )
    comment = models.CharField(max_length=1024, blank=True, verbose_name=_('Комментарий при запросе роли'))
    deprive_at = models.DateTimeField(null=True, blank=True, verbose_name=_('Дата окончания действия роли'))
    review_at = models.DateTimeField(
        null=True,
        blank=True,
        verbose_name=_('Дата первого пересмотра роли'),
        help_text=_('последующие пересмотры происходят по логике, определённой в workflow'),
    )
    deprive_after_days = models.IntegerField(
        null=True,
        blank=True,
        verbose_name=_('Время жизни роли'),
        help_text=_('в днях'),
    )
    requested_at = models.DateTimeField(null=True, blank=True, verbose_name=_('Дата запроса'))
    request_id = models.IntegerField(null=True, blank=True, verbose_name=_('Идентификатор запроса роли'))
    x_system_request_id = models.CharField(
        max_length=255,
        blank=True,
        verbose_name=_('Идентификатор http-запроса роли'),
        help_text=_('Идентификатор, переданный в заголовке `X-System-Request-Id` при запросе роли'),
    )
    criterion = models.ForeignKey(to='courses.Criterion', null=True, blank=True, verbose_name=_('критерий'))

    STATUS_REQUESTED = 'requested'
    STATUS_REQUESTED_EARLIER = 'requested_earlier'
    STATUS_NOT_REQUESTED = 'not_requested'

    STATUSES = (
        (STATUS_REQUESTED, _('Роль запрошена')),
        (STATUS_REQUESTED_EARLIER, _('Роль была запрошена ранее')),
        (STATUS_NOT_REQUESTED, _('Роль не запрошена')),
    )

    @property
    def status(self):
        if self.request_id is not None and self.request_id != 0:
            return self.STATUS_REQUESTED
        if self.request_id == 0:
            return self.STATUS_REQUESTED_EARLIER
        return self.STATUS_NOT_REQUESTED

    def __str__(self):
        return '{user} - {system}{path}'.format(
            user=self.user, system=self.system, path=self.path,
        )

    class Meta:
        verbose_name = _('запрос idm-роли')
        verbose_name_plural = _('запросы idm-ролей')
