import logging
import uuid

from django.utils import timezone

from ..idm_client import IDMHTTPError
from ..idm_client import client as idm_client
from ..models import UserIDMRoleRequest

logger = logging.getLogger(__name__)


def push_idm_request(user_idm_role_request, force=False):
    if user_idm_role_request.requested_at is not None and not force:
        return

    x_system_request_id = str(uuid.uuid4())

    resp = idm_client.request_role(
        system=user_idm_role_request.system,
        path=user_idm_role_request.path,
        user=user_idm_role_request.user.username,
        comment=user_idm_role_request.comment,
        fields_data=user_idm_role_request.fields_data,
        deprive_at=user_idm_role_request.deprive_at,
        review_at=user_idm_role_request.review_at,
        deprive_after_days=user_idm_role_request.deprive_after_days,
        x_system_request_id=x_system_request_id,
    )
    if 'id' not in resp:
        logger.warning(f'x_system_request_id={x_system_request_id}, response={resp}')

    UserIDMRoleRequest.objects.filter(id=user_idm_role_request.id).update(
        requested_at=timezone.now(),
        x_system_request_id=x_system_request_id,
        request_id=resp.get('id', 0),
    )
