from django.db.models.signals import post_save

from .models import UserIDMRoleRequest
from .tasks import push_idm_request_task


def push_idm_request_signal(sender, instance, **kwargs):
    if instance.requested_at is None:
        push_idm_request_task.delay(user_idm_role_request_id=instance.id)


post_save.connect(push_idm_request_signal, UserIDMRoleRequest)
