from celery.utils.log import get_task_logger

from django.conf import settings

from kelvin.celery import app
from kelvin.common.decorators.task_logger import logged_task

from .idm_client import IDMHTTPError
from .models import UserIDMRoleRequest
from .services.push_idm_request import push_idm_request

logger = get_task_logger(__name__)


@logged_task
@app.task(bind=True, max_retries=10)
def push_idm_request_task(self, user_idm_role_request_id):
    user_idm_role_request = UserIDMRoleRequest.objects.filter(id=user_idm_role_request_id).first()
    if user_idm_role_request is not None:
        try:
            push_idm_request(user_idm_role_request=user_idm_role_request)
        except IDMHTTPError as exc:
            if exc.response.status_code != 409:
                raise self.retry(exc=exc, countdown=settings.CELERY_DEFAULT_COUNTDOWN)
    else:
        logger.error('UserIDMRoleRequest with id {} not found'.format(user_idm_role_request_id))
