from django.contrib import admin

from kelvin.lesson_assignments.models import LessonAssignment


class LessonAssignmentAdmin(admin.ModelAdmin):
    """
    Админка модели `LessonAssignment`
    """
    list_display = (
        'id',
        'clesson',
        'student',
    )
    list_select_related = (
        'clesson',
        'student',
    )
    search_fields = ('clesson__id', 'student__username')

    raw_id_fields = (
        'clesson',
        'student',
    )


admin.site.register(LessonAssignment, LessonAssignmentAdmin)
