from django.db import transaction

from kelvin.courses.models import CourseStudent
from kelvin.lesson_assignments.models import LessonAssignment


def ensure_clesson_assignments(clesson):
    """
    Проверяет, что назначения соответствуют группировке задач в курсозанятии

    :param clesson: курсозанятие, по которому проверяетются назначения
    """
    if not clesson.lesson.lessonproblemlink_set.filter(
            group__isnull=False).exists():
        # если в занятии нет вариаций, то всё в порядке
        return

    assignments_to_update = []
    assignments_to_update_old_ids = []
    problem_links = clesson.lesson.lessonproblemlink_set.all().order_by(
        'group')

    # находим учеников без объекта назначения
    student_ids = set(
        CourseStudent.objects.filter(
            course=clesson.course_id,
        )
        .values_list('student_id', flat=True)
    )
    assignments = LessonAssignment.objects.filter(clesson=clesson)
    missed_student_ids = student_ids - set(assignment.student_id for assignment in assignments)
    for student_id in missed_student_ids:
        assignment = LessonAssignment(
            clesson=clesson,
            student_id=student_id,
            problems=[],
        )
        assignment.ensure_variations(problem_links)
        assignments_to_update.append(assignment)

    # проверяем существующие назначения
    for assignment in assignments:
        if not assignment.ensure_variations(problem_links):
            assignments_to_update_old_ids.append(assignment.id)
            assignment.pk = None
            assignments_to_update.append(assignment)

    # удаляем существовавшие и создаем новые назначения
    if assignments_to_update:
        with transaction.atomic():
            LessonAssignment.objects.filter(
                id__in=assignments_to_update_old_ids).delete()
            LessonAssignment.objects.bulk_create(assignments_to_update)

    return len(assignments_to_update)
