from django.db.models.signals import post_save
from django.dispatch import receiver

from kelvin.courses.models import CourseLessonLink

from .services import ensure_clesson_assignments


@receiver(post_save, sender=CourseLessonLink)
def ensure_clesson_assignments_on_save(sender, instance, **kwargs):
    """
    При сохранении курсозанятия проверяем назначения вариативных занятий
    """
    ensure_clesson_assignments(instance)
